package parser;

/**
 * Right parenthesis token class.
 */
public class RightPToken extends AToken {
    /**
     * Interface for a visitor to visit a right parenthesis token.
     */
    public static interface IRightPVisitor extends ITokVisitor {
        /**
         * Case for a right parenthesis token.
         *
         * @param host  right parenthesis token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object rightPCase(RightPToken host, Object param);
    }

    /**
     * Singleton instance.
     */
    public final static RightPToken Singleton = new RightPToken();

    /**
     * Private singleton constructor.
     */
    private RightPToken() {
        super(")");
    }

    /**
     * Execute the right parenthesis case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public Object execute(ITokVisitor algo, Object param) {
        return (algo instanceof IRightPVisitor) ?
               ((IRightPVisitor) algo).rightPCase(this, param) :
               algo.defaultCase(this, param);
    }
}

